#include <iostream>
#include <map>
#include <stack>
#include <algorithm>
#include <vector>

using namespace std;

using ll = long long;


ll nadji_rastojanje_ako_je_k_poz(ll tr_x, ll tr_y, ll x2, ll y2){
	ll x_presecne_tacke = (tr_y - y2 + x2);
	return abs(x_presecne_tacke - tr_x);
}
ll nadji_rastojanje_ako_je_k_neg(ll tr_x, ll tr_y, ll x2, ll y2){
	ll x_presecne_tacke = (x2 + y2 - tr_y);
	return abs(x_presecne_tacke - tr_x);
//	return x_presecne_tacke;
}

struct jarbol{
	ll x;
	ll y;
	ll i;
};

int main(){
	ll n;
	cin >> n;
	jarbol niz[n];
	for(ll i = 0; i < n; i++){
		cin >> niz[i].x;
		niz[i].i = i; 
	}
	for(ll i = 0; i < n; i++){
		cin >> niz[i].y;
	}
	
	sort(niz, niz + n, [](const jarbol& a, const jarbol& b){
		return a.x < b.x;
	});
	
	vector<ll> visi_sa_desna(n,-1);
	vector<ll> visi_sa_leva(n,-1);
	stack<jarbol> jarboli;
	for(ll i = 0; i < n; i++){
		while(!jarboli.empty() and niz[i].y >= jarboli.top().y){
			visi_sa_desna[jarboli.top().i] = nadji_rastojanje_ako_je_k_poz(jarboli.top().x, jarboli.top().y, niz[i].x, niz[i].y);
			jarboli.pop();
		}
		jarboli.push(niz[i]);
	}
	
	stack<jarbol> jarboli1;
	for(ll i = n-1; i >= 0; i--){
		while(!jarboli1.empty() and niz[i].y >= jarboli1.top().y){
			visi_sa_leva[jarboli1.top().i] = nadji_rastojanje_ako_je_k_neg(jarboli1.top().x, jarboli1.top().y, niz[i].x, niz[i].y);
			jarboli1.pop();
		}
		jarboli1.push(niz[i]);
	}
	for(ll i = 0;  i < n; i++){
    	int leva = visi_sa_leva[i];
    	int desna = visi_sa_desna[i];
		
		if(leva == -1 and desna == -1) cout << -1 << '\n';
    	else if(leva == -1) cout << desna << '\n';
    	else if(desna == -1) cout << leva << '\n';
    	else cout << min(leva, desna) << '\n';
	}
	
	return 0;
}